
#include "includes.h"
#include "auth.h"
#include "packet.h"
#include "captcha.h"
#include "xmalloc.h"

#define CAPTCHA_WORDLENGTH 8
#define NUM_DISTRACTERS 5

char screens[CAPTCHA_WORDLENGTH][CAPTCHA_IMGROWS][CAPTCHA_IMGCOLS];

void make_captcha_packet( Authctxt *authctxt ) {
    int iLetter, iDistracter;
    char image1[CAPTCHA_IMGROWS][CAPTCHA_IMGCOLS];
    char image2[CAPTCHA_IMGROWS][CAPTCHA_IMGCOLS];
    int xloc, yloc;
    double angle, scale;
    int dindex;
    static int initialized = 0;

    if ( !initialized ) {
        srandom(time(0));
        initialized = 1;
    }

    packet_put_int( CAPTCHA_IMGCOLS );
    packet_put_int( CAPTCHA_IMGROWS );
    packet_put_int( CAPTCHA_WORDLENGTH );

    authctxt->captcha = xmalloc( CAPTCHA_WORDLENGTH+1 );
    rand_word( authctxt->captcha, CAPTCHA_WORDLENGTH );

    for ( iLetter = 0; iLetter < CAPTCHA_WORDLENGTH; iLetter++ ) {
        image_init( screens[iLetter] );
        for ( iDistracter = 0; iDistracter < NUM_DISTRACTERS; iDistracter++ ) {
            image_init( image1 );
            randloc( &yloc, &xloc, &angle, &scale );
            dindex = randint( 26, 51 );
            image_insert( image1, dindex, yloc, xloc, angle, scale );
            image_shift( image1, image2 );
            image_overlay( image2, screens[iLetter] );
        }
        image_init( image1 );
        randloc( &yloc, &xloc, &angle, &scale );
        dindex = authctxt->captcha[iLetter]-'a';
        image_insert( image1, dindex, yloc, xloc, angle, scale );
        image_shift( image1, image2 );
        image_overlay( image2, screens[iLetter] );
    }

    packet_put_raw( screens,
                    CAPTCHA_WORDLENGTH * CAPTCHA_IMGROWS * CAPTCHA_IMGCOLS );

}

