#ifndef CAPTCHA_DEF
#define CAPTCHA_DEF

/* characters to use for full and empty pixels in the bitmap */

#define FULL_CHAR '*'
#define EMPTY_CHAR ' '

/* the "image" */

#define CAPTCHA_IMGROWS 24
#define CAPTCHA_IMGCOLS 80

/* some useful macros */

#define ROUND(x) (int)floor(x+0.5)
#define RADIANS(x) ((double)(x)/180.0 * M_PI)
#define DEGREES(x) ((double)(x)/M_PI * 180.0)

/* 9x15 font */

#define FONTHEIGHT 15
#define FONTWIDTH 9

#define LOWERCASEno

extern int letters[][FONTHEIGHT][FONTWIDTH];

void image_insert( char image[][CAPTCHA_IMGCOLS], int letter_index, int row,
                   int col, double angle, double stretchfactor );

void image_init( char image[][CAPTCHA_IMGCOLS] );

int randint( int imin, int imax );

double randdbl( double dmin, double dmax );

void randloc( int *yloc, int *xloc, double *angle, double *scale );

void debugf_init( char *filename );

void debugf( char *msg );

void image_shift( char image1[][CAPTCHA_IMGCOLS], char image2[][CAPTCHA_IMGCOLS] );

void image_overlay( char image1[][CAPTCHA_IMGCOLS], char image2[][CAPTCHA_IMGCOLS] );

void rand_word( char *buf, int size );

#endif

