
#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <assert.h>

#include "captcha.h"

int letters[][FONTHEIGHT][FONTWIDTH] = {

#ifdef LOWERCASE
    /* Lowercase version */

    /* 'a' */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 1, 1, 1, 1, 1, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 1, 1, 1, 1, 1, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 1, 1, 0 }, 
        { 0, 0, 1, 1, 1, 1, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* 'b' */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 1, 1, 1, 1, 0, 0 }, 
        { 0, 1, 1, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 1, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 1, 1, 1, 1, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* 'c' */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 1, 1, 1, 1, 1, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 1, 1, 1, 1, 1, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* 'd' */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 1, 1, 1, 1, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 1, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 1, 1, 0 }, 
        { 0, 0, 1, 1, 1, 1, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* 'e' */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 1, 1, 1, 1, 1, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 1, 1, 1, 1, 1, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 1, 1, 1, 1, 1, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* 'f' */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 1, 1, 0, 0 }, 
        { 0, 0, 0, 1, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 1, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 1, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 1, 0, 0, 0, 0, 0 }, 
        { 0, 1, 1, 1, 1, 1, 0, 0, 0 }, 
        { 0, 0, 0, 1, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 1, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 1, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 1, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* 'g' */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 1, 1, 1, 1, 0, 1, 0 }, 
        { 0, 1, 1, 0, 0, 0, 1, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 1, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 1, 0, 0 }, 
        { 0, 0, 1, 1, 1, 1, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 1, 1, 1, 1, 1, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 1, 1, 1, 1, 1, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* 'h' */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 1, 1, 1, 1, 0, 0 }, 
        { 0, 1, 1, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* 'i' */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 1, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 1, 1, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 1, 1, 1, 1, 1, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* 'j' */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 1, 1, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 1, 1, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 1, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 1, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 1, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 1, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 1, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 1, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 1, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 1, 0, 0 }, 
        { 0, 0, 1, 1, 1, 1, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* 'k' */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 1, 1, 0, 0 }, 
        { 0, 1, 0, 1, 1, 0, 0, 0, 0 }, 
        { 0, 1, 1, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 1, 1, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 1, 1, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* 'l' */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 1, 1, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 1, 1, 1, 1, 1, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* 'm' */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 1, 1, 0, 1, 1, 0, 0 }, 
        { 0, 1, 0, 0, 1, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 1, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 1, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 1, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 1, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* 'n' */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 1, 1, 1, 1, 0, 0 }, 
        { 0, 1, 1, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* 'o' */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 1, 1, 1, 1, 1, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 1, 1, 1, 1, 1, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* 'p' */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 1, 1, 1, 1, 0, 0 }, 
        { 0, 1, 1, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 1, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 1, 1, 1, 1, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* 'q' */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 1, 1, 1, 1, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 1, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 1, 1, 0 }, 
        { 0, 0, 1, 1, 1, 1, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* 'r' */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 1, 1, 1, 0, 0 }, 
        { 0, 0, 1, 1, 0, 0, 0, 1, 0 }, 
        { 0, 0, 1, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 1, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 1, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 1, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 1, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* 's' */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 1, 1, 1, 1, 1, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 1, 1, 1, 1, 1, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 1, 1, 1, 1, 1, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* 't' */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 1, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 1, 0, 0, 0, 0, 0 }, 
        { 0, 1, 1, 1, 1, 1, 1, 0, 0 }, 
        { 0, 0, 0, 1, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 1, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 1, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 1, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 1, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 1, 1, 1, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* 'u' */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 1, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 1, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 1, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 1, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 1, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 1, 0, 0 }, 
        { 0, 0, 1, 1, 1, 1, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* 'v' */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 1, 0, 0, 0, 1, 0, 0 }, 
        { 0, 0, 1, 0, 0, 0, 1, 0, 0 }, 
        { 0, 0, 0, 1, 0, 1, 0, 0, 0 }, 
        { 0, 0, 0, 1, 0, 1, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* 'w' */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 1, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 1, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 1, 0, 0, 1, 0 }, 
        { 0, 1, 0, 1, 0, 1, 0, 1, 0 }, 
        { 0, 0, 1, 0, 0, 0, 1, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* 'x' */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 1, 0, 0, 0, 1, 0, 0 }, 
        { 0, 0, 0, 1, 0, 1, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 1, 0, 1, 0, 0, 0 }, 
        { 0, 0, 1, 0, 0, 0, 1, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* 'y' */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 1, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 1, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 1, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 1, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 1, 0, 0 }, 
        { 0, 1, 0, 0, 0, 1, 1, 0, 0 }, 
        { 0, 0, 1, 1, 1, 0, 1, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 1, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 1, 0, 0 }, 
        { 0, 0, 1, 1, 1, 1, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* 'z' */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 1, 1, 1, 1, 1, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 1, 0, 0 }, 
        { 0, 0, 0, 0, 0, 1, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 1, 0, 0, 0, 0, 0 }, 
        { 0, 0, 1, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 1, 1, 1, 1, 1, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
#else
    /* Uppercase version */

    /* 'A' */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 1, 0, 1, 0, 0, 0 }, 
        { 0, 0, 1, 0, 0, 0, 1, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 1, 1, 1, 1, 1, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* 'B' */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 1, 1, 1, 1, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 1, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 1, 0, 0 }, 
        { 0, 1, 1, 1, 1, 1, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 1, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 1, 0, 0 }, 
        { 0, 1, 1, 1, 1, 1, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* 'C' */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 1, 1, 1, 1, 1, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 1, 1, 1, 1, 1, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* 'D' */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 1, 1, 1, 1, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 1, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 1, 0, 0 }, 
        { 0, 1, 1, 1, 1, 1, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* 'E' */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 1, 1, 1, 1, 1, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 1, 1, 1, 1, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 1, 1, 1, 1, 1, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* 'F' */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 1, 1, 1, 1, 1, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 1, 1, 1, 1, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* 'G' */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 1, 1, 1, 1, 1, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 1, 1, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 1, 1, 1, 1, 1, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* 'H' */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 1, 1, 1, 1, 1, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* 'I' */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 1, 1, 1, 1, 1, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 1, 1, 1, 1, 1, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* 'J' */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 1, 1, 1, 1 }, 
        { 0, 0, 0, 0, 0, 0, 1, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 1, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 1, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 1, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 1, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 1, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 1, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 1, 0, 0 }, 
        { 0, 0, 1, 1, 1, 1, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* 'K' */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 1, 0, 0 }, 
        { 0, 1, 0, 0, 0, 1, 0, 0, 0 }, 
        { 0, 1, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 1, 1, 1, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 1, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 1, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 1, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* 'L' */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 1, 1, 1, 1, 1, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* 'M' */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 1, 0, 0, 0, 1, 1, 0 }, 
        { 0, 1, 0, 1, 0, 1, 0, 1, 0 }, 
        { 0, 1, 0, 1, 0, 1, 0, 1, 0 }, 
        { 0, 1, 0, 0, 1, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 1, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* 'N' */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 1, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 1, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 1, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 1, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 1, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* 'O' */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 1, 1, 1, 1, 1, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 1, 1, 1, 1, 1, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* 'P' */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 1, 1, 1, 1, 1, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 1, 1, 1, 1, 1, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* 'Q' */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 1, 1, 1, 1, 1, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 1, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 1, 0, 0, 1, 0 }, 
        { 0, 0, 1, 1, 1, 1, 1, 0, 0 }, 
        { 0, 0, 0, 0, 0, 1, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 1, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* 'R' */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 1, 1, 1, 1, 1, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 1, 1, 1, 1, 1, 0, 0 }, 
        { 0, 1, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 1, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 1, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* 'S' */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 1, 1, 1, 1, 1, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 1, 1, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 1, 1, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 1, 1, 1, 1, 1, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* 'T' */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 1, 1, 1, 1, 1, 1, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* 'U' */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 1, 1, 1, 1, 1, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* 'V' */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 1, 0, 0, 0, 1, 0, 0 }, 
        { 0, 0, 1, 0, 0, 0, 1, 0, 0 }, 
        { 0, 0, 1, 0, 0, 0, 1, 0, 0 }, 
        { 0, 0, 0, 1, 0, 1, 0, 0, 0 }, 
        { 0, 0, 0, 1, 0, 1, 0, 0, 0 }, 
        { 0, 0, 0, 1, 0, 1, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* 'W' */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 1, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 1, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 1, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 1, 0, 0, 1, 0 }, 
        { 0, 1, 0, 1, 0, 1, 0, 1, 0 }, 
        { 0, 0, 1, 0, 0, 0, 1, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* 'X' */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 1, 0, 0, 0, 1, 0, 0 }, 
        { 0, 0, 0, 1, 0, 1, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 1, 0, 1, 0, 0, 0 }, 
        { 0, 0, 1, 0, 0, 0, 1, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* 'Y' */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 1, 0, 0, 0, 1, 0, 0 }, 
        { 0, 0, 0, 1, 0, 1, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* 'Z' */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 1, 1, 1, 1, 1, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 1, 0, 0 }, 
        { 0, 0, 0, 0, 0, 1, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 1, 0, 0, 0, 0, 0 }, 
        { 0, 0, 1, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 1, 1, 1, 1, 1, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
#endif
    /* Distracters */

    /* id 1 */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 1, 0, 1, 0, 0, 0 }, 
        { 0, 0, 1, 0, 0, 0, 1, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* id 2 */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 1, 1, 1, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 1, 0 }, 
        { 0, 0, 0, 1, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 1, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 1, 1, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* id 3 */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 1, 1, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 1, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 1, 0, 0, 0 }, 
        { 0, 1, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 1, 1, 1, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* id 4 */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 1, 1, 1, 1, 1, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 1, 1, 1, 1, 1, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* id 5 */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 1, 1, 1, 1, 1, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* id 6 */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 1, 0, 1, 0, 0, 0 }, 
        { 0, 0, 0, 1, 0, 1, 0, 0, 0 }, 
        { 0, 0, 0, 1, 0, 1, 0, 0, 0 }, 
        { 0, 0, 1, 0, 0, 0, 1, 0, 0 }, 
        { 0, 0, 1, 0, 0, 0, 1, 0, 0 }, 
        { 0, 0, 1, 0, 0, 0, 1, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* id 7 */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 1, 0, 1, 0, 1, 0, 0, 0 }, 
        { 0, 0, 1, 0, 0, 0, 1, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* id 8 */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 1, 1, 1, 1, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 1, 1, 1, 1, 1, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* id 9 */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 1, 1, 1, 1, 1, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 1, 1, 1, 1, 1, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* id 10 */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 1, 0 }, 
        { 0, 0, 0, 1, 0, 1, 0, 1, 0 }, 
        { 0, 0, 1, 0, 0, 0, 1, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* id 11 */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 1, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 1, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 1, 0, 1, 0, 0, 0 }, 
        { 0, 0, 1, 0, 0, 0, 1, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* id 12 */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 1, 1, 1, 1, 1, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* id 13 */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 1, 1, 1, 1, 1, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* id 14 */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 1, 1, 1, 1, 1, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* id 15 */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 1, 1, 1, 1, 1, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* id 16 */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 1, 0, 0 }, 
        { 0, 0, 0, 0, 0, 1, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 1, 0, 1, 0, 0, 0 }, 
        { 0, 0, 1, 0, 0, 0, 1, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* id 17 */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 1, 1, 1, 1, 1, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 1, 1, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 1, 1, 1, 1, 1, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* id 18 */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 1, 1, 1, 1, 1, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* id 19 */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 1, 1, 1, 1, 1, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* id 20 */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 1, 1, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 1, 1, 1, 1, 1, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* id 21 */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 1, 1, 1, 0 }, 
        { 0, 0, 0, 0, 0, 1, 0, 1, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 1, 0 }, 
        { 0, 0, 0, 1, 0, 0, 0, 1, 0 }, 
        { 0, 0, 1, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* id 22 */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 1, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 1, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 1, 1, 1, 0 }, 
        { 0, 0, 0, 0, 0, 1, 0, 0, 0 }, 
        { 0, 0, 0, 0, 1, 0, 0, 0, 0 }, 
        { 0, 0, 0, 1, 0, 0, 0, 0, 0 }, 
        { 0, 0, 1, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* id 23 */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 1, 1, 1, 1, 1, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* id 24 */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 1, 1, 0 }, 
        { 0, 1, 0, 0, 0, 1, 0, 1, 0 }, 
        { 0, 1, 0, 0, 1, 0, 0, 1, 0 }, 
        { 0, 1, 0, 1, 0, 0, 0, 1, 0 }, 
        { 0, 1, 1, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* id 25 */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 1, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 1, 0, 0, 0, 0, 0 }, 
        { 0, 0, 1, 1, 1, 1, 1, 0, 0 }, 
        { 0, 1, 0, 0, 1, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 1, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 1, 1, 1, 1, 1, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
    /* id 26 */
    {
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 1, 1, 1, 1, 1, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 1, 0 }, 
        { 0, 0, 0, 0, 1, 1, 1, 0, 0 }, 
        { 0, 0, 1, 1, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 1, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
        { 0, 0, 0, 0, 0, 0, 0, 0, 0 }, 
    },
};

#define XYSTRETCH 0.5

/* insert specified character into the image at specified scale/pos/orient */

void image_insert( char image[][CAPTCHA_IMGCOLS], int letter_index, int row,
                   int col, double angle, double stretchfactor ) {
    int i, j, ii, jj;
    int radius = (int)(1.2 * stretchfactor * (FONTHEIGHT+1)/2 *
                       ((double)FONTHEIGHT/(double)FONTWIDTH));

    for ( i = row - radius; i <= row + radius; i++ ) {
        for ( j = col - radius; j <= col + radius; j++ ) {
            if ( i >= 0 && j >= 0 && i < CAPTCHA_IMGROWS && j < CAPTCHA_IMGCOLS ) {
                double x = (double)(j-col);
                double y = (double)(i-row) *
                           (double)FONTHEIGHT / (double)FONTWIDTH;
                double r = sqrt( x*x + y*y );
                double angr = atan2( y, x );
                double xjj, yii;
                int lfull=0, cfull=0, rfull=0, ufull=0, dfull=0;

                angr -= angle;
                x = cos( angr ) * r / stretchfactor;
                y = sin( angr ) * r / stretchfactor;
                xjj = x * XYSTRETCH + (double)(int)(FONTWIDTH/2);
                yii = y * (double)FONTWIDTH / (double)FONTHEIGHT +
                                (double)(int)(FONTHEIGHT/2);
                ii = (int)ROUND(yii);
                jj = (int)ROUND(xjj);

                if ( ii < 0 || jj < 0 || ii >= FONTHEIGHT || jj >= FONTWIDTH ) {
                    continue;
                }

                cfull = letters[letter_index][ii][jj];
                if ( jj > 0 && letters[letter_index][ii][jj-1] ) lfull = 1;
                if ( jj < FONTWIDTH-1 && letters[letter_index][ii][jj+1] )
                    rfull = 1;
                if ( ii > 0 && letters[letter_index][ii-1][jj] ) ufull = 1;
                if ( ii < FONTHEIGHT-1 && letters[letter_index][ii+1][jj] )
                    dfull = 1;

                if ( cfull ) image[i][j] = FULL_CHAR;
                else if ( lfull && xjj-jj < 0 ) image[i][j] = FULL_CHAR;
                else if ( rfull && xjj-jj > 0 ) image[i][j] = FULL_CHAR;
                else if ( dfull && yii-ii > 0 ) image[i][j] = FULL_CHAR;
                else if ( ufull && yii-ii < 0 ) image[i][j] = FULL_CHAR;
            }
        }
    }
}

/* clear the "image" buffer */

void image_init( char image[][CAPTCHA_IMGCOLS] ) {
    int i, j;
    for ( i = 0; i < CAPTCHA_IMGROWS; i++ ) {
        for ( j = 0; j < CAPTCHA_IMGCOLS; j++ ) {
            image[i][j] = EMPTY_CHAR;
        }
    }
}

/* return a random integer in the specified range */

int randint( int imin, int imax ) {
    int i;
    assert( imax > imin );
    i = (int)((double)random() / (double)RAND_MAX * (imax-imin+1));
    assert( i >= 0 && i <= imax-imin );
    return imin+i;
}

/* return a random double in the specified range */

double randdbl( double dmin, double dmax ) {
    double d = (double)random() / (double)RAND_MAX;
    return dmin + ( d * ( dmax-dmin ));
}

/* add random noise to the "image" */

void image_addnoise( char image[][CAPTCHA_IMGCOLS], int n ) {
    int i, r, c;
    for ( i = 0; i < n; i++ ) {
        r = randint(0,CAPTCHA_IMGROWS-1);
        c = randint(0,CAPTCHA_IMGCOLS-1);
        image[r][c] = FULL_CHAR;
    }
}

/* clear random locations in the "image" */

void image_subnoise( char image[][CAPTCHA_IMGCOLS], int n ) {
    int i, r, c;
    for ( i = 0; i < n; i++ ) {
        r = randint(0,CAPTCHA_IMGROWS-1);
        c = randint(0,CAPTCHA_IMGCOLS-1);
        image[r][c] = EMPTY_CHAR;
    }
}

/* add some "bars" to the image as noise */

void image_barnoise( char image[][CAPTCHA_IMGCOLS], int nbars ) {
    int i, j;
    for ( i = 0; i < nbars; i++ ) {
        int dir = randint(0,1);
        int len = randint(1,5);
        int r = randint(0,CAPTCHA_IMGROWS-1);
        int c = randint(0,CAPTCHA_IMGCOLS-1);
        for ( j = 0; j < len; j++ ) {
            image[r][c] = FULL_CHAR;
            if ( dir == 0 ) r++;
            else c++;
            if ( r >= CAPTCHA_IMGROWS || c >= CAPTCHA_IMGCOLS ) break;
        }
    }
}

/* get a random position/orientation for a character */

#define SCALEMIN 1.3
#define SCALEMAX 1.7
#define ROTMAX ( RADIANS( 20.0 ) )

void randloc( int *yloc, int *xloc, double *angle, double *scale ) {
    int imax, imin;
    double dmax, dmin;
    int yrad, xrad;

    /* First get a random scale */

    dmin = SCALEMIN;
    dmax = SCALEMAX;
    *scale = randdbl( dmin, dmax );

    /* Get random row */

    yrad = *scale * 1.2 * FONTHEIGHT / 2;
    imin = yrad;
    imax = CAPTCHA_IMGROWS - yrad;

    if ( imin >= imax ) *yloc = CAPTCHA_IMGROWS/2;
    else *yloc = randint( imin, imax );

    /* Get random col */

    xrad = *scale * 3.6 * FONTWIDTH / 2;
    imin = xrad;
    imax = CAPTCHA_IMGCOLS - xrad;

    if ( imin >= imax ) *xloc = CAPTCHA_IMGCOLS/2;
    else *xloc = randint( imin, imax );

    /* Get random rotation */

    dmin = -ROTMAX;
    dmax = ROTMAX;
    *angle = randdbl( dmin, dmax );
}

static char *g_pFilename = NULL;

void debugf_init( char *filename ) {
    g_pFilename = filename;
    FILE *fp = fopen( g_pFilename, "w" );
    fclose( fp );
}

void debugf( char *msg ) {
    FILE *fp = fopen( g_pFilename, "a" );
    fprintf( fp, "%s\n", msg );
    fclose( fp );
}

#define SHIFT_PROB 0.33

void image_shift( char image1[][CAPTCHA_IMGCOLS], char image2[][CAPTCHA_IMGCOLS] ) {
    int i;
    int j;
    int offset = 0;
    for ( i = 0; i < CAPTCHA_IMGROWS; i++ ) {
        double r = randdbl( 0, 1 );
        if ( r < SHIFT_PROB ) offset--;
        else if ( r > 1.0 - SHIFT_PROB ) offset++;
        for ( j = 0; j < CAPTCHA_IMGCOLS; j++ ) {
            if ( j + offset >= 0 && j + offset < CAPTCHA_IMGCOLS ) {
                image2[i][j] = image1[i][j+offset];
            } else {
                image2[i][j] = EMPTY_CHAR;
            }
        }
    }
}

void image_overlay( char image1[][CAPTCHA_IMGCOLS], char image2[][CAPTCHA_IMGCOLS] ) {
    int i,j,ii,jj;

    for ( i = 0; i < CAPTCHA_IMGROWS; i++ ) {
        for ( j = 0; j < CAPTCHA_IMGCOLS; j++ ) {
            if ( image1[i][j] != EMPTY_CHAR ) {
                image2[i][j] = image1[i][j];
            } else {
                int close = 0;
#define BORDER 5
                for ( ii = i-BORDER; ii <= i+BORDER; ii++ ) {
                    for ( jj = j-BORDER; jj <= j+BORDER; jj++ ) {
                        if ( ii >= 0 && ii < CAPTCHA_IMGROWS &&
                             jj >= 0 && jj < CAPTCHA_IMGCOLS &&
                             image1[ii][jj] != EMPTY_CHAR ) {
                            close = 1;
                            break;
                        }
                    }
                    if ( close ) {
                        image2[i][j] = EMPTY_CHAR;
                        break;
                    }
                }
            }
        }
    }
}

/* Pick a random string of letters.  Do not allow 'd' or 'o', since
   they are easily confused. */

void rand_word( char *buf, int size ) {
    int i;
    for ( i = 0; i < size; i++ ) {
        buf[i] = ' ';
        while( buf[i] == ' ' || buf[i] == 'd' || buf[i] == 'o' ) {
            buf[i] = 'a' + randint( 0, 25 );
        }
    }
    buf[i] = 0;
}

