
#include "includes.h"
RCSID("$OpenBSD: auth2-passwd.c,v 1.2 2002/05/31 11:35:15 markus Exp $");

#include "xmalloc.h"
#include "packet.h"
#include "log.h"
#include "auth.h"
#include "monitor_wrap.h"
#include "servconf.h"
#include "dispatch.h"
#include "ssh2.h"
#include "sshcaptcha.h"

/* import */
extern ServerOptions options;

static int
captcha_check( Authctxt *authctxt, char *captcha_resp ) {
    if ( strcmp( authctxt->captcha, captcha_resp ) == 0 ) {
        return 1;
    }
    return 0;
}

static void
input_userauth_captcha_response(int type, u_int32_t seq, void *ctxt)
{
	Authctxt *authctxt = ctxt;
        char *password, *captcha_resp;
        int authenticated = 0;
        int change;
        u_int len;

	if (authctxt == NULL)
		fatal("input_userauth_captcha_request: no authctxt");

        dispatch_set(SSH2_MSG_USERAUTH_CAPTCHA_RESPONSE, NULL );

        captcha_resp = packet_get_string(NULL);
        change = packet_get_char();
        if (change)
            log("password change not supported");
        password = packet_get_string(&len);
        packet_check_eom();

        if ( captcha_check( authctxt, captcha_resp )) {
            if (PRIVSEP(auth_password(authctxt, password)) == 1 && authctxt->valid
#ifdef HAVE_CYGWIN
                    && check_nt_auth(1, authctxt->pw)
#endif
               )
                authenticated = 1;
        }
        memset(password, 0, len);
        xfree(password);
        xfree(captcha_resp);

        authctxt->postponed = 0;
        userauth_finish( authctxt, authenticated, "captcha-password" );
}

static int
userauth_captcha_passwd(Authctxt *authctxt)
{
    if (authctxt == NULL)
        fatal("input_userauth_captcha_request: no authctxt");

    /* There is no method-specific data with this method */
    packet_check_eom();

    /* Set up to receive response */

    dispatch_set(SSH2_MSG_USERAUTH_CAPTCHA_RESPONSE,
                 &input_userauth_captcha_response);

    /* Send a captcha to the client */

    packet_start( SSH2_MSG_CAPTCHA );
    make_captcha_packet( authctxt );
    packet_send();

    authctxt->postponed = 1;
    return 1;
}


Authmethod method_captcha_passwd = {
	"captcha-password",
	userauth_captcha_passwd,
	&options.password_authentication
};

